/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.entity.data.IAnimation;
import noppes.npcs.api.entity.data.IEmotion;
import noppes.npcs.api.handler.IAnimationHandler;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.EmotionConfig;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.util.Util;

public class AnimationController
implements IAnimationHandler {
    private static AnimationController instance;
    public final TreeMap<Integer, AnimationConfig> animations = new TreeMap();
    public final TreeMap<Integer, EmotionConfig> emotions = new TreeMap();

    public static AnimationController getInstance() {
        if (instance == null) {
            instance = new AnimationController();
        }
        return instance;
    }

    @Override
    public IAnimation createNewAnim() {
        AnimationConfig ac = new AnimationConfig();
        ac.id = this.getUnusedAnimId();
        this.animations.put(ac.id, ac);
        return ac;
    }

    @Override
    public IEmotion createNewEmtn() {
        EmotionConfig ec = new EmotionConfig();
        ec.id = this.getUnusedEmtnId();
        this.emotions.put(ec.id, ec);
        return ec;
    }

    @Override
    public IAnimation getAnimation(int animationId) {
        if (this.animations.containsKey(animationId)) {
            return this.animations.get(animationId);
        }
        return null;
    }

    @Override
    public IAnimation getAnimation(String animationName) {
        for (IAnimation iAnimation : this.animations.values()) {
            if (!iAnimation.getName().equalsIgnoreCase(animationName)) continue;
            return iAnimation;
        }
        return null;
    }

    @Override
    public IEmotion getEmotion(int emotionId) {
        if (this.emotions.containsKey(emotionId)) {
            return this.emotions.get(emotionId);
        }
        return null;
    }

    @Override
    public IEmotion getEmotion(String emotionName) {
        for (IEmotion iEmotion : this.emotions.values()) {
            if (!iEmotion.getName().equalsIgnoreCase(emotionName)) continue;
            return iEmotion;
        }
        return null;
    }

    @Override
    public IAnimation[] getAnimations() {
        return this.animations.values().toArray(new IAnimation[0]);
    }

    public List<AnimationConfig> getAnimations(List<Integer> ids) {
        ArrayList<AnimationConfig> list = new ArrayList<AnimationConfig>();
        if (ids == null || ids.isEmpty()) {
            return list;
        }
        block0: for (AnimationConfig ac : this.animations.values()) {
            for (int id : ids) {
                if (ac.getId() != id) continue;
                list.add(ac);
                continue block0;
            }
        }
        return list;
    }

    public int getUnusedEmtnId() {
        int i;
        int id = 0;
        Iterator<Integer> iterator = this.emotions.keySet().iterator();
        while (iterator.hasNext() && (i = iterator.next().intValue()) == id) {
            id = i + 1;
        }
        return id;
    }

    public int getUnusedAnimId() {
        int i;
        int id = 0;
        Iterator<Integer> iterator = this.animations.keySet().iterator();
        while (iterator.hasNext() && (i = iterator.next().intValue()) == id) {
            id = i + 1;
        }
        return id;
    }

    public IAnimation loadAnimation(NBTTagCompound nbtAnimation) {
        if (nbtAnimation == null || !nbtAnimation.func_150297_b("ID", 3) || nbtAnimation.func_74762_e("ID") < 0) {
            return null;
        }
        if (this.animations.containsKey(nbtAnimation.func_74762_e("ID"))) {
            AnimationConfig ac = this.animations.get(nbtAnimation.func_74762_e("ID"));
            ac.load(nbtAnimation);
            return ac;
        }
        AnimationConfig ac = new AnimationConfig();
        ac.load(nbtAnimation);
        this.animations.put(ac.id, ac);
        return this.animations.get(nbtAnimation.func_74762_e("ID"));
    }

    public IEmotion loadEmotion(NBTTagCompound nbtEmotion) {
        if (nbtEmotion == null || !nbtEmotion.func_150297_b("ID", 3) || nbtEmotion.func_74762_e("ID") < 0) {
            return null;
        }
        if (this.emotions.containsKey(nbtEmotion.func_74762_e("ID"))) {
            this.emotions.get(nbtEmotion.func_74762_e("ID")).read(nbtEmotion);
            return this.emotions.get(nbtEmotion.func_74762_e("ID"));
        }
        EmotionConfig ec = new EmotionConfig();
        ec.read(nbtEmotion);
        this.emotions.put(nbtEmotion.func_74762_e("ID"), ec);
        return this.emotions.get(nbtEmotion.func_74762_e("ID"));
    }

    public void loadAnimations() {
        File emtnDir;
        File animDir;
        CustomNpcs.debugData.start(null);
        LogWriter.info("Start load animations");
        boolean needSave = false;
        this.animations.clear();
        this.emotions.clear();
        if (CustomNpcs.Dir != null) {
            File oldFile = new File(CustomNpcs.Dir, "animations.dat");
            if (oldFile.exists()) {
                try {
                    this.loadOldAnimations(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(oldFile.toPath(), new OpenOption[0])));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                Util.instance.removeFile(oldFile);
            }
            if ((animDir = new File(CustomNpcs.Dir, "animations")).exists()) {
                try {
                    this.loadAnimations(animDir);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
            if ((emtnDir = new File(CustomNpcs.Dir, "emotions")).exists()) {
                try {
                    this.loadEmotions(emtnDir);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
        }
        if ((animDir = new File(CustomNpcs.getWorldSaveDirectory(), "animations")).exists()) {
            try {
                this.loadAnimations(animDir);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        } else {
            needSave = true;
        }
        if ((emtnDir = new File(CustomNpcs.getWorldSaveDirectory(), "emotions")).exists()) {
            try {
                this.loadEmotions(emtnDir);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        } else {
            needSave = true;
        }
        this.loadDefaultAnimations();
        if (needSave) {
            this.save();
        }
        LogWriter.info("End load animations");
        CustomNpcs.debugData.end(null);
    }

    private void loadOldAnimations(NBTTagCompound compound) {
        NBTTagList listA = compound.func_150295_c("Animations", 10);
        if (compound.func_150297_b("Animations", 9)) {
            listA = compound.func_150295_c("Animations", 10);
        } else if (compound.func_150297_b("Data", 9)) {
            listA = compound.func_150295_c("Data", 10);
        }
        for (int i = 0; i < listA.func_74745_c(); ++i) {
            AnimationConfig anim = (AnimationConfig)this.loadAnimation(listA.func_150305_b(i));
            if (anim.id >= 43) continue;
            anim.immutable = true;
        }
        this.emotions.clear();
        NBTTagList listE = compound.func_150295_c("Emotions", 10);
        for (int i = 0; i < listE.func_74745_c(); ++i) {
            EmotionConfig emtn = (EmotionConfig)this.loadEmotion(listE.func_150305_b(i));
            emtn.immutable = true;
        }
    }

    private void loadAnimations(File file) {
        for (File f : Objects.requireNonNull(file.listFiles())) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(f.toPath(), new OpenOption[0]));
                int id = -1;
                try {
                    id = Integer.parseInt(f.getName().toLowerCase().replace(".dat", ""));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                if (id != -1 && this.animations.containsKey(id)) {
                    nbt.func_74768_a("ID", this.getUnusedAnimId());
                } else {
                    nbt.func_74768_a("ID", id);
                }
                this.loadAnimation(nbt);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    private void loadEmotions(File file) {
        for (File f : Objects.requireNonNull(file.listFiles())) {
            try {
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(f.toPath(), new OpenOption[0]));
                    int id = -1;
                    try {
                        id = Integer.parseInt(f.getName().toLowerCase().replace(".dat", ""));
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    if (id != -1 && this.animations.containsKey(id)) {
                        nbt.func_74768_a("ID", this.getUnusedAnimId());
                    } else {
                        nbt.func_74768_a("ID", id);
                    }
                    this.loadEmotion(nbt);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    private void loadDefaultAnimations() {
        NBTTagList listE;
        InputStream inputStream = Util.instance.getModInputStream("a_def.dat");
        if (inputStream == null) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        try {
            compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        NBTTagList listA = compound.func_150295_c("Animations", 10);
        if (listA.func_74745_c() != 0) {
            for (int i = 0; i < listA.func_74745_c(); ++i) {
                IAnimation iAnim;
                NBTTagCompound nbt = listA.func_150305_b(i);
                int id = nbt.func_74762_e("ID");
                if (!(!this.animations.containsKey(id) || this.animations.get((Object)Integer.valueOf((int)id)).immutable && this.animations.get((Object)Integer.valueOf((int)id)).name.equals(nbt.func_74779_i("Name")))) {
                    boolean found = false;
                    for (AnimationConfig anim : this.animations.values()) {
                        if (!anim.name.equals(nbt.func_74779_i("Name"))) continue;
                        id = anim.id;
                        found = true;
                        break;
                    }
                    if (!found) {
                        id = this.getUnusedAnimId();
                    }
                    nbt.func_74768_a("ID", id);
                }
                if ((iAnim = this.loadAnimation(nbt)) == null) continue;
                ((AnimationConfig)iAnim).immutable = true;
            }
        }
        if ((listE = compound.func_150295_c("Emotions", 10)).func_74745_c() != 0) {
            for (int i = 0; i < listE.func_74745_c(); ++i) {
                NBTTagCompound nbt = listE.func_150305_b(i);
                int id = nbt.func_74762_e("ID");
                if (!(!this.emotions.containsKey(id) || this.emotions.get((Object)Integer.valueOf((int)id)).immutable && this.emotions.get((Object)Integer.valueOf((int)id)).name.equals(nbt.func_74779_i("Name")))) {
                    boolean found = false;
                    for (EmotionConfig emtn : this.emotions.values()) {
                        if (!emtn.name.equals(nbt.func_74779_i("Name"))) continue;
                        id = emtn.id;
                        found = true;
                        break;
                    }
                    if (!found) {
                        id = this.getUnusedEmtnId();
                    }
                    nbt.func_74768_a("ID", id);
                }
                this.loadEmotion(nbt);
            }
        }
    }

    @Override
    public boolean removeAnimation(int animationId) {
        if (this.animations.containsKey(animationId)) {
            this.animations.remove(animationId);
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAnimation(String animationName) {
        for (int id : this.animations.keySet()) {
            if (!this.animations.get(id).getName().equalsIgnoreCase(animationName)) continue;
            this.animations.remove(id);
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEmotion(int emotionId) {
        if (this.emotions.containsKey(emotionId)) {
            this.emotions.remove(emotionId);
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEmotion(String emotionName) {
        for (int id : this.emotions.keySet()) {
            if (!this.emotions.get(id).getName().equalsIgnoreCase(emotionName)) continue;
            this.emotions.remove(id);
            this.save();
            return true;
        }
        return false;
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        File animDir = CustomNpcs.getWorldSaveDirectory("animations");
        if (animDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        if (!animDir.exists()) {
            animDir.mkdirs();
        }
        for (int id : this.animations.keySet()) {
            if (this.animations.get((Object)Integer.valueOf((int)id)).immutable) continue;
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.animations.get(id).save(), (OutputStream)Files.newOutputStream(new File(animDir, id + ".dat").toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        File emtnDir = CustomNpcs.getWorldSaveDirectory("emotions");
        if (emtnDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        if (!emtnDir.exists()) {
            emtnDir.mkdirs();
        }
        for (int id : this.emotions.keySet()) {
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.emotions.get(id).save(), (OutputStream)Files.newOutputStream(new File(emtnDir, id + ".dat").toPath(), new OpenOption[0]));
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void sendTo(EntityPlayerMP player) {
        if (CustomNpcs.Server != null && CustomNpcs.Server.func_71264_H()) {
            return;
        }
        Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.AnimationData, new NBTTagCompound()});
        for (AnimationConfig ac : this.animations.values()) {
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.AnimationData, ac.save()});
        }
        Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.EmotionData, new NBTTagCompound()});
        for (EmotionConfig ec : this.emotions.values()) {
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.EmotionData, ec.save()});
        }
    }

    @Override
    public IEmotion[] getEmotions() {
        return this.emotions.values().toArray(new IEmotion[0]);
    }
}

